Map {
  background-color: white;
  buffer-size: 128;
}

@book: "DejaVu Sans Book";
@bold: "DejaVu Sans Bold";
@oblique: "DejaVu Sans Oblique";
@water: #7cd1f3;
@forest: #9ad578;

#tgi {
  text-name: [Intitulé];
  text-face-name: @bold;
  text-size: 14;
  text-wrap-width: 100;
  text-halo-radius: 1.5;
  text-allow-overlap: true;
/*
  text-dy: 6;
  marker-width:6;
  marker-fill:#f45;
  marker-line-color:#813;
  marker-allow-overlap:true;
  marker-ignore-placement:true;
*/
}

#tgi_poly {
  opacity: 0.1;
  [justice-_1="4cac9ed7293594648a00edf3"] { polygon-fill:red; }
  [justice-_1="4cac9e61293594648a000580"] { polygon-fill:red; }
  [justice-_1="4cac9e87293594648a004cc8"] { polygon-fill:red; }
  [justice-_1="4cac9e61293594648a0005ee"] { polygon-fill:red; }
  [justice-_1="4cac9e6a293594648a00179a"] { polygon-fill:red; }

  [justice-_1="4cac9e6a293594648a0017b6"] { polygon-fill:pink; }
  [justice-_1="4cac9e61293594648a0005ef"] { polygon-fill:pink; }
  [justice-_1="4cac9ed7293594648a00ee0b"] { polygon-fill:pink; }
  [justice-_1="4cac9e61293594648a0005f1"] { polygon-fill:pink; }
  [justice-_1="4cac9e61293594648a0005bf"] { polygon-fill:pink; }

  [justice-_1="4cac9e61293594648a0005be"] { polygon-fill:purple; }
  [justice-_1="4cac9e61293594648a000581"] { polygon-fill:purple; }
  [justice-_1="4cac9e61293594648a0005f0"] { polygon-fill:purple; }
  [justice-_1="4cac9e6a293594648a00187f"] { polygon-fill:purple; }
  [justice-_1="4cac9e6a293594648a0017b5"] { polygon-fill:purple; }

  [justice-_1="4cac9e61293594648a0005f2"] { polygon-fill:green; }
  [justice-_1="4cac9ed7293594648a00ee09"] { polygon-fill:green; }

  ::text [zoom>=12] {
    text-face-name: @oblique;
    text-name: "  "+[justice-_3]+"  ";
    text-placement: line;
    text-fill: #333;
    text-dy: -8;
    text-spacing: 250;
  }

  
}

#communes {
  ::text [zoom>=12] {
    text-face-name: @book;
    text-name: "  "+[nom]+"  ";
    text-placement: line;
    text-fill: #666;
    text-dy: -8;
    text-spacing: 50;
    line-width: 0.5;
    line-opacity: 0.25;
  }
}

#roads {
::line {
  [zoom>=14] { line-width:0.5; line-color: grey; }
  [type="motorway"] { line-width:3; line-color: #6392f2; }
  [type="motorway_link"] { line-width:3; line-color: #6392f2; }
  [type="trunk"] { line-width:3; line-color: #df5252; }
  [type="trunk_link"] { line-width:3; line-color: #df5252; }
  [type="primary"][zoom>=9] { line-width:2; line-color: #df5252; }
  [type="secondary"][zoom>=10] { line-width:2; line-color: #ff8d35; }
  [type="tertiary"][zoom>=11] { line-width:1.5; line-color: #ffcb25; }
}

::text {
  text-name: "";
  text-face-name: @book;
  text-placement: line;
  text-halo-radius: 1;
  [type="motorway"] { text-name: [ref]; }
  [type="trunk"] { text-name: [ref]; }
  [type="primary"][zoom>=9] { text-name: [ref]; }
  [type="secondary"][zoom>=10] { text-name: [ref]; }
  [type="tertiary"][zoom>=11] {  text-name: [ref]; }
}

}


#places {
/*
  marker-width:3;
  marker-fill:black;
  marker-line-color:black;
  marker-allow-overlap:true;
  marker-ignore-placement:true;
  text-dy: 6;
*/
  text-name: [name];
  text-face-name: @book;
  text-size: 10;
  text-halo-radius: 1.5;
  text-avoid-edges: true;
  [type="hamlet"]{ text-name: ""; marker-width: 0; }
  [type="locality"]{ text-name: ""; marker-width: 0; }
  [type="neighbourhood"]{ text-name: ""; marker-width: 0; }
  [type="isolated_dwellin"]{ text-name: ""; marker-width: 0; }
}


#points {
  [type='motorway_junctio']{
    marker-width:6;
  marker-fill:#f45;
  marker-line-color:#813;
  marker-allow-overlap:true;
  marker-ignore-placement:true;
   }
}

#waterways {
  [type='river'] { line-width:2; line-color: @water; }
  [type='canal'] { line-width:1; line-color: @water; }
}


#railways {
  [type='rail']{
  a/line-color:black;
  a/line-width:2;
  b/line-color:white;
  b/line-width:1.5;
  b/line-dasharray: 8,8;
  }
}


#natural {
  polygon-opacity:0; 
  [type='water'] { polygon-fill: @water; polygon-opacity: 1; }
  [type='riverbank'] { polygon-fill: @water; polygon-opacity: 1; }
  [type='forest'] { polygon-fill: @forest; polygon-opacity: 0.8; }
  [type='park'] { polygon-fill: @forest; polygon-opacity: 0.8; }
}


#landuse {
  polygon-opacity:0; 
  [type='residential'] { polygon-fill: #ccc; polygon-opacity: 1; }
}
